% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future_invoke_map.R
\name{future_invoke_map}
\alias{future_invoke_map}
\alias{future_invoke_map_chr}
\alias{future_invoke_map_dbl}
\alias{future_invoke_map_int}
\alias{future_invoke_map_lgl}
\alias{future_invoke_map_dfr}
\alias{future_invoke_map_dfc}
\title{Invoke functions via futures}
\usage{
future_invoke_map(.f, .x = list(NULL), ..., .env = NULL,
  .progress = FALSE, .options = future_options())

future_invoke_map_chr(.f, .x = list(NULL), ..., .env = NULL,
  .progress = FALSE, .options = future_options())

future_invoke_map_dbl(.f, .x = list(NULL), ..., .env = NULL,
  .progress = FALSE, .options = future_options())

future_invoke_map_int(.f, .x = list(NULL), ..., .env = NULL,
  .progress = FALSE, .options = future_options())

future_invoke_map_lgl(.f, .x = list(NULL), ..., .env = NULL,
  .progress = FALSE, .options = future_options())

future_invoke_map_dfr(.f, .x = list(NULL), ..., .env = NULL,
  .progress = FALSE, .options = future_options())

future_invoke_map_dfc(.f, .x = list(NULL), ..., .env = NULL,
  .progress = FALSE, .options = future_options())
}
\arguments{
\item{.f}{A list of functions.}

\item{.x}{A list of argument-lists the same length as \code{.f} (or length 1).
The default argument, \code{list(NULL)}, will be recycled to the same length as
\code{.f}, and will call each function with no arguments
(apart from any supplied in \code{...}.)}

\item{...}{Additional arguments passed to each function.}

\item{.env}{Environment in which \code{\link[=do.call]{do.call()}} should
evaluate a constructed expression. This only matters if you pass
as \code{.f} the name of a function rather than its value, or as
\code{.x} symbols of objects rather than their values.}

\item{.progress}{A logical, for whether or not to print a progress bar for
multiprocess, multisession, and multicore plans.}

\item{.options}{The \code{future} specific options to use with the workers. This must
be the result from a call to \code{\link[=future_options]{future_options()}}.}
}
\description{
These functions work exactly the same as \code{\link[purrr:invoke_map]{purrr::invoke_map()}} functions, but allow
you to invoke in parallel.
}
\examples{

\donttest{
plan(multiprocess)
}

df <- dplyr::tibble(
  f = c("runif", "rpois", "rnorm"),
  params = list(
    list(n = 10),
    list(n = 5, lambda = 10),
    list(n = 10, mean = -3, sd = 10)
  )
)

future_invoke_map(df$f, df$params)


}
