% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spa_functions.R
\name{spa_set_classification}
\alias{spa_set_classification}
\title{Setting a new classification for fuzzy topological relationships}
\usage{
spa_set_classification(classes, mfs)
}
\arguments{
\item{classes}{A character vector containing linguistic values that characterizes different situations of fuzzy topological relationships.}

\item{mfs}{A vector containing membership functions generated by the function \code{genmf} of the FuzzyR package. Their domain have to be in [0, 1].}
}
\value{
No return values, called for side effects.
}
\description{
This functions configures a new set of linguistic values and their corresponding membership functions to be used by fuzzy topological relationships.
}
\details{
This function replaces the default linguistic values employed by fuzzy topological relationships.
Each membership function \emph{i} of the parameter \code{mfs} represents the class \emph{i} of the parameter \code{classes}.
The length of these parameters have to be same.
}
\examples{

library(tibble)
library(sf)
library(FuzzyR)

set.seed(456)

# some random points to create pgeometry objects by using the function spa_creator
tbl = tibble(x = runif(10, min= 0, max = 30), 
             y = runif(10, min = 0, max = 30), 
             z = runif(10, min = 0, max = 50))

#getting the convex hull on the points to clipping the construction of plateau region objects
pts <- st_as_sf(tbl, coords = c(1, 2))
ch <- st_convex_hull(do.call(c, st_geometry(pts)))

pregions <- spa_creator(tbl, base_poly = ch, fuzz_policy = "fcp", k = 2)

# Showing the default list of classes
spa_overlap(pregions$pgeometry[[1]], pregions$pgeometry[[2]], ret = "list")

# Changing the default classification

classes <- c("small", "medium", "large")
small <- genmf("trapmf", c(0, 0.3, 0.4, 0.6))
medium <- genmf("trapmf", c(0.4, 0.6, 0.8, 1))
large <- genmf("trapmf", c(0.6, 0.8, 1, 1))

spa_set_classification(classes, c(small, medium, large))

spa_overlap(pregions$pgeometry[[1]], pregions$pgeometry[[2]], ret = "list")

}
\references{
\href{https://ieeexplore.ieee.org/document/8491565}{Carniel, A. C.; Schneider, M. Spatial Plateau Algebra: An Executable Type System for Fuzzy Spatial Data Types. In Proceedings of the 2018 IEEE International Conference on Fuzzy Systems (FUZZ-IEEE 2018), pp. 1-8, 2018.}
}
