% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalfragilityinternal.R
\name{survivalfragilityinternal}
\alias{survivalfragilityinternal}
\title{Survival analyysis fragility internal function}
\usage{
survivalfragilityinternal(formula, data, conf.level = 0.95)
}
\arguments{
\item{formula}{Model formula which will be evaluated by survdiff()}

\item{data}{Dataframe with values for model forma, passed to survdiff()}

\item{conf.level}{Significance level, set by default to 95\%}
}
\value{
Returns the fragility index for a single run of a survival difference
}
\description{
Compute the fragility of a coefficient in a log-rank survival test. This function is called by the wrapper function survivalfragility(), which replicates this function many times to obtain stable estimates.
}
\examples{
library(survival)
lung$status <- lung$status - 1 # recode status as a 0/1 variable (mandatory)

survivalfragilityinternal(Surv(time, status) ~ pat.karno + strata(inst), data=lung)

}

