% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{minibar}
\alias{minibar}
\title{mini barplots chunk wrapper}
\usage{
minibar(value, max = NULL, barcol = "#CCCCCC", bg = "transparent",
  width = 1, height = 0.2)
}
\arguments{
\item{value}{values containing the bar size}

\item{max}{max bar size}

\item{barcol}{bar color}

\item{bg}{background color}

\item{width, height}{size of the resulting png file in inches}
}
\description{
This function is used to insert bars into
flextable with function \code{\link{compose}}.
It should be used inside a call to \code{\link{as_paragraph}}
}
\note{
PowerPoint cannot mix images and text in a paragraph, images
are removed when outputing to PowerPoint format.
}
\examples{
myft <- flextable( head(iris, n = 10 ))

myft <- compose( myft, j = 1,
  value = as_paragraph(
    minibar(value = Sepal.Length, max = max(Sepal.Length))
  ),
  part = "body")

autofit(myft)
}
\seealso{
\code{\link{compose}}, \code{\link{as_paragraph}}

Other chunk elements for paragraph: \code{\link{as_chunk}},
  \code{\link{as_image}}, \code{\link{hyperlink_text}}
}
\concept{chunk elements for paragraph}
