% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_paragraph}
\alias{as_paragraph}
\title{concatenate chunks in a flextable}
\usage{
as_paragraph(..., list_values = NULL)
}
\arguments{
\item{...}{chunk elements that are defining paragraph}

\item{list_values}{a list of chunk elements that are defining paragraph. If
specified argument \code{...} is unused.}
}
\description{
The function is concatenating text and images within paragraphs of
a flextable object, this function is to be used with function \code{\link{compose}}.
}
\examples{
library(officer)
myft <- flextable( head(iris, n = 10 ))

myft <- compose( myft, j = 1,
  value = as_paragraph(
    minibar(value = Sepal.Length, max = max(Sepal.Length)),
    " ",
    as_chunk( Sepal.Length, formater = formatC,
             props = fp_text(color = "orange") ),
    " blah blah"
  ),
  part = "body")

autofit(myft)
}
\seealso{
\code{\link{as_chunk}}, \code{\link{minibar}},
\code{\link{as_image}}, \code{\link{hyperlink_text}}
}
