% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{fill_values}
\alias{fill_values}
\alias{fill_values.pivot_table}
\title{Fill in missing values}
\usage{
fill_values(pt)

\method{fill_values}{pivot_table}(pt)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}
}
\value{
A \code{pivot_table} object.
}
\description{
Fills with NA missing values in a pivot table value array.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

To correctly carry out this operation, the number of rows and columns that
contain labels must be defined, and the table must only contain the pivot
table rows and columns.
}
\examples{

pt <-
  pt_ex |>
  remove_top(1) |>
  define_labels(n_col = 2, n_row = 2) |>
  fill_values()

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{extract_labels}()},
\code{\link{fill_labels}()},
\code{\link{remove_agg}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_empty}()},
\code{\link{remove_k}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{replace_dec}()},
\code{\link{unpivot}()}
}
\concept{pivot table transformation functions}
