% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabolic_rate.R
\name{metabolic_rate}
\alias{metabolic_rate}
\title{A function to calculate metabolic rates}
\usage{
metabolic_rate(temp, troph, asp, B0, m_max, m, a, growth_g_day, f)
}
\arguments{
\item{temp}{Temperature in degrees Celsius}

\item{troph}{Trophic level (from 1 to 5)}

\item{asp}{The caudal fin aspect ratio , a proxy for activity level}

\item{B0}{Constant for resting metabolic rate. If NA, function will calculate an average.}

\item{m_max}{Maximum biomass fish (in g)}

\item{m}{Wet weight fish (in g)}

\item{a}{Resting metabolic rate mass-scaling exponent}

\item{growth_g_day}{Daily growth in grams of wet weight}

\item{f}{Activity scope (from 1 to 4)}
}
\value{
A dataframe with metabolic rates.
}
\description{
All model parameters below were estimated by Barneche & Allen 2018 Ecology
Letters doi: 10.1111/ele.12947. These parameters are for the best model
(Model 2 in the paper online supplementary material) of fish resting
metabolic rates reported in the paper, which also includes trophic level as
a covariate.
}
\details{
All model parameters below were estimated by 
Barneche & Allen 2018 Ecology Letters doi: 10.1111/ele.12947. 
These parameters are for the best model 
(Model 2 in the paper online supplementary material) 
of fish resting metabolic rates reported in the paper, 
which also includes trophic level as a covariate.
}
\examples{
library(fishflux)
fishflux::metabolic_rate(temp = 27, m_max = 600, m = 300, asp = 3,
troph = 2, f = 2, growth_g_day = 0.05, B0 = 0.2, a = 0.6 )

}
\keyword{fish}
\keyword{metabolism}
