% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_plot.R
\name{missing_pairs}
\alias{missing_pairs}
\title{Missing values pairs plot}
\usage{
missing_pairs(
  .data,
  dependent = NULL,
  explanatory = NULL,
  use_labels = TRUE,
  title = NULL,
  position = "stack",
  showXAxisPlotLabels = TRUE,
  showYAxisPlotLabels = FALSE
)
}
\arguments{
\item{.data}{Data frame.}

\item{dependent}{Character vector. Optional name of dependent variable.}

\item{explanatory}{Character vector. Optional name(s) of explanatory
variables.}

\item{use_labels}{Use variable label names in plot labelling.}

\item{title}{Character vector. Optional title for plot.}

\item{position}{For discrete variables, choose "stack" or "fill" to show
counts or proportions.}

\item{showXAxisPlotLabels}{Show x-axis plot labels.}

\item{showYAxisPlotLabels}{Show y-axis plot labels.}
}
\value{
A plot matrix comparing missing values in all variables against each
  other.
}
\description{
Compare the occurence of missing values in all variables by each other.
Suggest limit the number of variables to a maximum of around six.
\code{Dependent} and \code{explanatory} are for convenience of variable
selection, are optional, and have no other specific function.
}
\examples{
\dontrun{
explanatory = c("age", "nodes", "age.factor", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = 'mort_5yr'
colon_s \%>\%
  missing_pairs(dependent, explanatory)
}
}
