% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalfit_internal_functions.R
\name{ff_formula}
\alias{ff_formula}
\alias{finalfit_formula}
\title{Generate formula as character string}
\usage{
ff_formula(dependent, explanatory, random_effect = NULL)

finalfit_formula(dependent, explanatory, random_effect = NULL)
}
\arguments{
\item{dependent}{Optional character vector: name(s) of depdendent
variable(s).}

\item{explanatory}{Optional character vector: name(s) of explanatory
variable(s).}

\item{random_effect}{Optional character vector: name(s) of random effect
variable(s).}
}
\value{
Character vector
}
\description{
Useful when passing finalfit dependent and explanatory lists to base R
functions
}
\examples{
explanatory = c("age", "nodes", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"
ff_formula(dependent, explanatory)

explanatory = c("age", "nodes", "sex.factor", "obstruct.factor", "perfor.factor")
dependent = "mort_5yr"
random_effect = "(age.factor | hospital)"
ff_formula(dependent, explanatory)
}
