% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw.R
\name{add_start}
\alias{add_start}
\title{A ggproto for drawing start points}
\usage{
add_start(dt, start_size = 5, start_alpha = 1, start_color = NULL, ...)
}
\arguments{
\item{dt}{A data object from the running the optimisation algorithm in guided tour}

\item{start_size}{numeric; the size of start point}

\item{start_alpha}{numeric; the alpha of start point}

\item{start_color}{the variable to be coloured by}

\item{...}{other aesthetics inherent from \code{explore_space_pca()}}
}
\value{
a wrapper for drawing start points in \code{explore_space_pca()}
}
\description{
This is  a wrapper function used by \code{explore_space_pca()} and
should be be called directly by the user
}
\examples{
library(ggplot2)
# construct the space and start df for plotting
space <- tibble::tibble(x0 = 0, y0 = 0, r = 5)
holes_1d_geo \%>\%
  compute_pca() \%>\%
  purrr::pluck("aug") \%>\%
  clean_method() \%>\%
  get_start()
}
\seealso{
Other draw functions: 
\code{\link{add_anchor}()},
\code{\link{add_anno}()},
\code{\link{add_dir_search}()},
\code{\link{add_end}()},
\code{\link{add_interp}()},
\code{\link{add_interp_last}()},
\code{\link{add_interrupt}()},
\code{\link{add_search}()},
\code{\link{add_space}()},
\code{\link{add_theo}()}
}
\concept{draw functions}
