% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_overlap.R
\name{pairwise_overlap}
\alias{pairwise_overlap}
\title{Feasibility of all Pairwise Ellipse Overlaps}
\usage{
pairwise_overlap(ell, ...)
}
\arguments{
\item{ell}{a list of at least two (non degenerate) ellipses; see
\code{\link{wrangle_ellipse}}.}

\item{...}{additional arguments to be passed to the low level funcitons.}
}
\value{
The \code{pairwise_overlap} function returns an object of
\code{\link[base]{class}} "\code{pairwise_overlap}" with the following
components:
\item{intersection }{ a data.frame where the two first columns specify the
  two ellipses intersected and the last coloumn indicate if they have a
  non-empty intersection.}
\item{call }{ the matched call.}
}
\description{
Determin if pairs of ellipses intersect non-emptily..
}
\details{
The \code{pairwise_overlap} functions goes through all pairs of ellipses from
\code{ell} and checks if their intersection is non-empty.

Note that if all pairs of ellipses intersect this does not mean that the
intersection of all the ellipses is non-empty. The example below is
constructed to illustrate this.
}
\examples{
## three different two dimensional ellipses
e1 <- list(c = c(0, 0.7), P = matrix(c(0.2, 0, 0, 3), ncol = 2), r = 0.5)
e2 <- list(c = c(0, 1), P = matrix(c(3, -1.5, -1.5, 1), ncol = 2), r = 1)
e3 <- list(c = c(1.5, 1), P = matrix(c(3, 1.2, 1.2, 1), ncol = 2), r = 1.2)
# Note: These ellipses have been chosen so all pairs intersect,
#       but the intersection of all three is empty.

# test pairwise overlaps
pairwise_overlap(list(e1, e2, e3))

## regression example
# generate data
n <- 100
E <- rbinom(n, 2, 0.5)
X <- rnorm(n, 3 * E, 1)
Y <- rnorm(n, 2 + 1.5 * E, 1)
m0 <- lm(Y ~ X, data = data.frame(Y,X), subset = (E == 0))
m1 <- lm(Y ~ X, data = data.frame(Y,X), subset = (E == 1))
m2 <- lm(Y ~ X, data = data.frame(Y,X), subset = (E == 2))

# create 95\% confidence ellipses and check pairwise intersection
q <- qchisq(0.95, 2) # df = 2, as there are two covariates (1, X)
E0 <- list(c = coefficients(m0), S = vcov(m0), r = q)
E1 <- list(c = coefficients(m1), S = vcov(m1), r = q)
E2 <- list(c = coefficients(m2), S = vcov(m2), r = q)
pairwise_overlap(list("model 0" = E0, "model 1" = E1, "model 2" = E2))

}
\seealso{
\code{\link{wrangle_ellipse}} for detailed on ellipse
parameterization.
}
