% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts.R
\name{add_contrast}
\alias{add_contrast}
\title{Add a contrast to a data frame}
\usage{
add_contrast(
  data,
  col,
  contrast = c("anova", "sum", "treatment", "helmert", "poly", "difference"),
  levels = NULL,
  ...,
  add_cols = TRUE,
  colnames = NULL
)
}
\arguments{
\item{data}{the data frame}

\item{col}{the column to recode}

\item{contrast}{the contrast to recode to}

\item{levels}{the levels of the factor in order}

\item{...}{arguments to pass to the contrast function (base or omit)}

\item{add_cols}{whether to just add the contrast to the existing column or also to create new explicit columns in the dataset (default)}

\item{colnames}{optional list of column names for the added contrasts}
}
\value{
the data frame with the recoded column and added columns (if add_cols == TRUE)
}
\description{
Add a contrast to a data frame
}
\examples{
df <- sim_design(between = list(time = 1:6), plot = FALSE) \%>\%
   add_contrast("time", "poly")

# test all polynomial contrasts
lm(y ~ time, df) \%>\% broom::tidy()

# test only the linear and quadratic contrasts
lm(y ~ `time^1` + `time^2`, df) \%>\% broom::tidy()
}
