% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readline_check.R
\name{readline_check}
\alias{readline_check}
\title{Check readline input}
\usage{
readline_check(
  prompt,
  type = c("numeric", "integer", "length", "grep"),
  min = -Inf,
  max = Inf,
  warning = NULL,
  default = NULL,
  ...
)
}
\arguments{
\item{prompt}{the prompt for readline}

\item{type}{what type of check to perform, one of  c("numeric", "integer", "length", "grep")}

\item{min}{the minimum value}

\item{max}{the maximum value}

\item{warning}{an optional custom warning message}

\item{default}{the default option to return if the entry is blank, NULL allows no default, the default value will be displayed after the text as [default]}

\item{...}{other arguments to pass to grep}
}
\value{
the validated result of readline
}
\description{
Check readline input
}
\examples{
if(interactive()){
readline_check("Type a number: ", "numeric")
readline_check("Type two characters: ", "length", min = 2, max = 2)
readline_check("Type at least 3 characters: ", "length", min = 3)
readline_check("Type no more than 4 characters: ", "length", max = 44)
readline_check("Type a letter and a number: ", "grep", pattern = "^[a-zA-Z]\\\\d$")
}
}
