% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_report.R
\name{qc_report}
\alias{qc_report}
\title{Build a QC Report}
\usage{
qc_report(qc.path, result.file, experiment = NULL, interpret = FALSE,
  template = NULL, preview = TRUE)
}
\arguments{
\item{qc.path}{path to the FastQC reports. Allowed values include: \itemize{ 
\item A path to a directory containing multiple zipped FastQC reports, \item
Or a single sample zipped FastQC report.  Partial match is allowed for sample name.}}

\item{result.file}{path to the result file prefix (e.g., path/to/qc-result).
Don't add the file extension.}

\item{experiment}{text specifying a short description of the experiment. For 
example experiment = "RNA sequencing of colon cancer cell lines".}

\item{interpret}{logical value. If TRUE, adds the interpretation of each 
module.}

\item{template}{a character vector specifying the path to an Rmd template. 
file.}

\item{preview}{logical value. If TRUE, shows a preview of the report.}
}
\description{
Create an HTML file containing FastQC reports of one or multiple 
 files. Inputs can be either a directory containing multiple FastQC reports 
 or a single sample FastQC report.
}
\examples{
\dontrun{
# Demo QC Directory
qc.path <- system.file("fastqc_results", package = "fastqcr")
qc.path

# List of files in the directory
list.files(qc.path)

# Multi QC report
qc_report(qc.path, result.file = "~/Desktop/result")

# QC Report of one sample with plot interpretation
 qc.file <- system.file("fastqc_results", "S1_fastqc.zip", package = "fastqcr")
 qc_report(qc.file, result.file = "~/Desktop/result",
   interpret = TRUE)
}

}
