% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_model_helpers.R
\name{determine_round_digits}
\alias{determine_round_digits}
\title{Determine rounding digits for time horizons}
\usage{
determine_round_digits(times)
}
\arguments{
\item{times}{Numeric vector of times.}
}
\value{
Integer number of digits between 0 and 6.
}
\description{
Computes a sensible number of decimal digits to round time horizons based on the minimal
positive separation between unique finite times.
}
\details{
Uses the smallest strictly positive difference among sorted unique finite times,
then returns \code{ceiling(-log10(min_diff))} truncated to \eqn{[0, 6]}.
}
\examples{
# Not run: determine_round_digits(c(0.1, 0.12, 0.125))
NULL

}
\keyword{internal}
