/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import jfm.lp.ConstraintBuilder;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;
import jfm.lp.MatrixRow;
import jfm.lp.ModelComponent;
import jfm.lp.SOS2Primitive;
import jfm.model.BoundaryComponent;
import jfm.model.Types;

public class DitchLengthComponent
extends BoundaryComponent {
    public DitchLengthComponent(double maxLen_, double hist, double createCost, double destCost, double maintain, double discountRate_) {
        super(ModelComponent.MCType.DITCHES, Types.ObjectiveType.DITCHES, maxLen_, hist, createCost, destCost, maintain, discountRate_);
        this.addConstraintBuilder(new DitchesSOS2Constraints(ConstraintBuilder.CBType.DITCHESSOS2, ModelComponent.MCType.DITCHES));
    }

    public class DitchesSOS2Constraints
    extends ConstraintBuilder {
        public DitchesSOS2Constraints(ConstraintBuilder.CBType type_, ModelComponent.MCType assoc) {
            super(type_, assoc);
        }

        public void build() {
            SOS2Primitive.buildConstraints(DitchLengthComponent.this.profit, DitchLengthComponent.this.matrix);
            if (DitchLengthComponent.this.curve != null) {
                SOS2Primitive.buildLink(DitchLengthComponent.this.curve, DitchLengthComponent.this.profit, DitchLengthComponent.this.matrix);
            } else {
                int row = DitchLengthComponent.this.matrix.numRows();
                MatrixRow rowpointer = new MatrixRow(0.0, 0.0, LPX.LPX_FX, row, "BindDitches", "BindingRow");
                DitchLengthComponent.this.matrix.addRow(rowpointer);
                ++row;
                rowpointer.addElement(new MatrixElement(DitchLengthComponent.this.profit.getDependentColumn(0), -1.0));
                rowpointer.addElement(new MatrixElement(DitchLengthComponent.this.lengthCounter.column(), 1.0));
                DitchLengthComponent.this.matrix.flagForAlwaysRebuild();
            }
        }
    }
}

