/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Collection;
import org.apache.commons.math.random.JDKRandomGenerator;
import org.apache.commons.math.random.RandomData;
import org.apache.commons.math.random.RandomGenerator;

public class RandomDataImpl
implements RandomData,
Serializable {
    private static final long serialVersionUID = -626730818244969716L;
    private RandomGenerator rand = null;
    private SecureRandom secRand = null;

    public RandomDataImpl() {
    }

    public RandomDataImpl(RandomGenerator rand) {
        this.rand = rand;
    }

    public String nextHexString(int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("length must be positive");
        }
        RandomGenerator ran = this.getRan();
        StringBuffer outBuffer = new StringBuffer();
        byte[] randomBytes = new byte[len / 2 + 1];
        ran.nextBytes(randomBytes);
        for (int i = 0; i < randomBytes.length; ++i) {
            Integer c = new Integer(randomBytes[i]);
            String hex = Integer.toHexString(c + 128);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            outBuffer.append(hex);
        }
        return outBuffer.toString().substring(0, len);
    }

    public int nextInt(int lower, int upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("upper bound must be > lower bound");
        }
        RandomGenerator rand = this.getRan();
        double r = rand.nextDouble();
        return (int)(r * (double)upper + (1.0 - r) * (double)lower + r);
    }

    public long nextLong(long lower, long upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("upper bound must be > lower bound");
        }
        RandomGenerator rand = this.getRan();
        double r = rand.nextDouble();
        return (long)(r * (double)upper + (1.0 - r) * (double)lower + r);
    }

    public String nextSecureHexString(int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("length must be positive");
        }
        SecureRandom secRan = this.getSecRan();
        MessageDigest alg = null;
        try {
            alg = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
        alg.reset();
        int numIter = len / 40 + 1;
        StringBuffer outBuffer = new StringBuffer();
        for (int iter = 1; iter < numIter + 1; ++iter) {
            byte[] randomBytes = new byte[40];
            secRan.nextBytes(randomBytes);
            alg.update(randomBytes);
            byte[] hash = alg.digest();
            for (int i = 0; i < hash.length; ++i) {
                Integer c = new Integer(hash[i]);
                String hex = Integer.toHexString(c + 128);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                outBuffer.append(hex);
            }
        }
        return outBuffer.toString().substring(0, len);
    }

    public int nextSecureInt(int lower, int upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("lower bound must be < upper bound");
        }
        SecureRandom sec = this.getSecRan();
        return lower + (int)(sec.nextDouble() * (double)(upper - lower + 1));
    }

    public long nextSecureLong(long lower, long upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("lower bound must be < upper bound");
        }
        SecureRandom sec = this.getSecRan();
        return lower + (long)(sec.nextDouble() * (double)(upper - lower + 1L));
    }

    public long nextPoisson(double mean) {
        if (mean <= 0.0) {
            throw new IllegalArgumentException("Poisson mean must be > 0");
        }
        double p = Math.exp(-mean);
        long n = 0L;
        double r = 1.0;
        double rnd = 1.0;
        RandomGenerator rand = this.getRan();
        while ((double)n < 1000.0 * mean) {
            rnd = rand.nextDouble();
            if ((r *= rnd) >= p) {
                ++n;
                continue;
            }
            return n;
        }
        return n;
    }

    public double nextGaussian(double mu, double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Gaussian std dev must be > 0");
        }
        RandomGenerator rand = this.getRan();
        return sigma * rand.nextGaussian() + mu;
    }

    public double nextExponential(double mean) {
        if (mean < 0.0) {
            throw new IllegalArgumentException("Exponential mean must be >= 0");
        }
        RandomGenerator rand = this.getRan();
        double unif = rand.nextDouble();
        while (unif == 0.0) {
            unif = rand.nextDouble();
        }
        return -mean * Math.log(unif);
    }

    public double nextUniform(double lower, double upper) {
        if (lower >= upper) {
            throw new IllegalArgumentException("lower bound must be < upper bound");
        }
        RandomGenerator rand = this.getRan();
        double u = rand.nextDouble();
        while (u <= 0.0) {
            u = rand.nextDouble();
        }
        return lower + u * (upper - lower);
    }

    private RandomGenerator getRan() {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
            this.rand.setSeed(System.currentTimeMillis());
        }
        return this.rand;
    }

    private SecureRandom getSecRan() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
            this.secRand.setSeed(System.currentTimeMillis());
        }
        return this.secRand;
    }

    public void reSeed(long seed) {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
        }
        this.rand.setSeed(seed);
    }

    public void reSeedSecure() {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(System.currentTimeMillis());
    }

    public void reSeedSecure(long seed) {
        if (this.secRand == null) {
            this.secRand = new SecureRandom();
        }
        this.secRand.setSeed(seed);
    }

    public void reSeed() {
        if (this.rand == null) {
            this.rand = new JDKRandomGenerator();
        }
        this.rand.setSeed(System.currentTimeMillis());
    }

    public void setSecureAlgorithm(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.secRand = SecureRandom.getInstance(algorithm, provider);
    }

    public int[] nextPermutation(int n, int k) {
        if (k > n) {
            throw new IllegalArgumentException("permutation k exceeds n");
        }
        if (k == 0) {
            throw new IllegalArgumentException("permutation k must be > 0");
        }
        int[] index = this.getNatural(n);
        this.shuffle(index, n - k);
        int[] result = new int[k];
        for (int i = 0; i < k; ++i) {
            result[i] = index[n - i - 1];
        }
        return result;
    }

    public Object[] nextSample(Collection c, int k) {
        int len = c.size();
        if (k > len) {
            throw new IllegalArgumentException("sample size exceeds collection size");
        }
        if (k == 0) {
            throw new IllegalArgumentException("sample size must be > 0");
        }
        Object[] objects = c.toArray();
        int[] index = this.nextPermutation(len, k);
        Object[] result = new Object[k];
        for (int i = 0; i < k; ++i) {
            result[i] = objects[index[i]];
        }
        return result;
    }

    private void shuffle(int[] list, int end) {
        int target = 0;
        for (int i = list.length - 1; i >= end; --i) {
            target = i == 0 ? 0 : this.nextInt(0, i);
            int temp = list[target];
            list[target] = list[i];
            list[i] = temp;
        }
    }

    private int[] getNatural(int n) {
        int[] natural = new int[n];
        for (int i = 0; i < n; ++i) {
            natural[i] = i;
        }
        return natural;
    }
}

