/*
 * Decompiled with CFR 0.152.
 */
package jfm.lp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jfm.lp.Matrix;
import jfm.lp.MatrixVariable;
import jfm.lp.ModelComponent;
import jfm.lp.SOS2Primitive;
import jfm.model.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Objective {
    private final List<MatrixVariable> variables = new ArrayList<MatrixVariable>();
    public final Types.ObjectiveType type;
    private double scaleFactor = 1.0;
    public final boolean isCurved;
    private final double[] yVals;
    private final double[] xVals;
    private final Objective linkedToObj;
    private final SOS2Primitive curve;

    public List<MatrixVariable> variables() {
        return Collections.unmodifiableList(this.variables);
    }

    public Objective(Types.ObjectiveType tp) {
        this.type = tp;
        this.isCurved = false;
        this.yVals = null;
        this.xVals = null;
        this.curve = null;
        this.linkedToObj = null;
    }

    public Objective(ModelComponent parent, Types.ObjectiveType tp, Objective linkedTo, double[] x, double[] y) {
        this.xVals = x;
        this.yVals = y;
        this.type = tp;
        this.isCurved = true;
        this.linkedToObj = linkedTo;
        this.scaleFactor = linkedTo.scaleFactor();
        linkedTo.setScaleFactor(0.0);
        this.curve = new SOS2Primitive(this.type.toString(), tp, this.xVals, this.yVals);
        this.curve.registerParent(parent);
        parent.registerCurve(this.curve);
    }

    public void buildConstraints(Matrix matrix) {
        SOS2Primitive.buildConstraints(this.curve, matrix);
        SOS2Primitive.bindToObjective(this.curve, this.linkedToObj, matrix);
    }

    public void initializeStructure() {
        if (this.curve == null) {
            throw new Error("Can't initialize structure on non-curved objective");
        }
        this.curve.initializeStructure();
    }

    public Objective copy() {
        return new Objective(this.type);
    }

    void clearVariables() {
        this.variables.clear();
    }

    void registerVariable(MatrixVariable newvar) {
        this.variables.add(newvar);
    }

    public void setScaleFactor(double wt) {
        this.scaleFactor = wt;
    }

    public double scaleFactor() {
        return this.scaleFactor;
    }
}

