/*
 * Decompiled with CFR 0.152.
 */
package jfm.lp;

import java.util.HashMap;
import jfm.xml.XMLSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LPX {
    LPX_FR(110, "lpx_fr"),
    LPX_LO(111, "lpx_lo"),
    LPX_UP(112, "lpx_up"),
    LPX_DB(113, "lpx_db"),
    LPX_FX(114, "lpx_fx"),
    LPX_LP(100, "lpx_lp"),
    LPX_MIP(101, "lpx_mip"),
    LPX_CV(160, "lpx_cv"),
    LPX_IV(161, "lpx_iv"),
    LPX_TERMON(1, "lpx_termon"),
    LPX_TERMOFF(0, "lpx_termoff"),
    LPX_NOTOPT(179, "lpx_notopt"),
    LPX_OPT(180, "lpx_opt"),
    LPX_FEAS(181, "lpx_feas"),
    LPX_INFEAS(182, "lpx_infeas"),
    LPX_NOFEAS(183, "lpx_nofeas"),
    LPX_UNBND(184, "lpx_unbnd"),
    LPX_UNDEF(185, "lpx_undef");

    private final int toCPP;
    public final String xmlname;
    private static HashMap<Integer, LPX> intToGLPKType;
    private static HashMap<String, LPX> xmlToGLPKType;

    private LPX(int intequiv, String xmln) {
        this.toCPP = intequiv;
        this.xmlname = xmln;
    }

    public int toCPP() {
        return this.toCPP;
    }

    public static LPX xmlToGLPKType(String str) throws XMLSyntaxException {
        if (xmlToGLPKType.containsKey(str)) {
            return xmlToGLPKType.get(str);
        }
        throw new XMLSyntaxException("The string " + str + " does not correspond to a LPX type");
    }

    public static LPX intToGLPKType(int iglpk) {
        if (intToGLPKType.containsKey(iglpk)) {
            return intToGLPKType.get(iglpk);
        }
        throw new Error("The integer " + iglpk + " does not correspond to a LPX type");
    }

    static {
        intToGLPKType = new HashMap();
        for (LPX lt : LPX.values()) {
            intToGLPKType.put(lt.toCPP, lt);
        }
        xmlToGLPKType = new HashMap();
        for (LPX lt : LPX.values()) {
            xmlToGLPKType.put(lt.xmlname, lt);
        }
    }
}

