/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import java.util.ArrayList;
import jfm.model.ELSOptionsComponent;
import jfm.model.Types;
import jfm.xml.JFMObjectParser;
import jfm.xml.ObjectParser;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;

public class ELSOptionsParser
extends JFMObjectParser {
    ELSOptionsParser(ObjectParser parent_) {
        this.parent = parent_;
        this.registerAttribute("paymentRate", mandatoryAttribute);
        this.registerAttribute("pointsRate", mandatoryAttribute);
        this.registerAttribute("options", mandatoryAttribute);
    }

    public void initializeObject() throws XMLObjectException, XMLSyntaxException {
        double payr = Double.parseDouble(this.getNamedAttribute("paymentRate"));
        double pointsr = Double.parseDouble(this.getNamedAttribute("pointsRate"));
        String[] optionnames = this.getNamedAttribute("options").split(",");
        ArrayList<Types.ELSCode> codes = new ArrayList<Types.ELSCode>();
        for (int i = 0; i < optionnames.length; ++i) {
            Types.ELSCode elsc = Types.xmlToELSCode(optionnames[i]);
            codes.add(elsc);
        }
        this.obj = new ELSOptionsComponent(payr, pointsr, codes);
    }

    protected boolean isPrimitive() {
        return false;
    }

    public String name() {
        return "ELS Options ";
    }

    public String parsesNode() {
        return "elsoptions";
    }

    public String toString() {
        return "elsoptions";
    }
}

