/*
 * Decompiled with CFR 0.152.
 */
package jfm.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jfm.xml.XMLException;
import jfm.xml.XMLObjectException;
import jfm.xml.XMLSyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectParser {
    protected ObjectParser parent;
    protected String textContent = null;
    protected Object obj = null;
    private Map<String, ArrayList<ObjectParser>> childParsers = new HashMap<String, ArrayList<ObjectParser>>();
    private Map<String, Integer> attributeTypes = new HashMap<String, Integer>();
    private Map<String, String> attributeValues = new HashMap<String, String>();
    protected static int mandatoryAttribute = 0;
    protected static int optionalAttribute = 1;

    public Object getObject() {
        return this.obj;
    }

    public abstract ObjectParser newNamedParser(String var1) throws XMLSyntaxException, XMLObjectException;

    protected String printNameAndAttributes() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.parsesNode() + " " + this.attributeValues);
        return buff.toString();
    }

    protected String printParsingTrace() {
        StringBuffer buff = new StringBuffer();
        if (this.parent != null) {
            buff.append("\n      at depth " + this.printNameAndAttributes());
            return buff.append(this.parent.printParsingTrace()).toString();
        }
        return "\n      at depth " + this.printNameAndAttributes();
    }

    protected ObjectParser getParent() {
        return this.parent;
    }

    protected ObjectParser getRootParent() {
        if (this.parent != null) {
            return this.parent.getRootParent();
        }
        return this;
    }

    protected abstract boolean isPrimitive();

    protected int getNodeDepth(int start) {
        if (this.parent != null) {
            return this.parent.getNodeDepth(start++);
        }
        return start;
    }

    public abstract void initializeObject() throws XMLObjectException, XMLSyntaxException;

    protected void registerAttribute(String name, int type) {
        this.attributeTypes.put(name, type);
    }

    protected ArrayList<ObjectParser> getParserList(String name) throws XMLObjectException {
        if (!this.childParsers.containsKey(name)) {
            throw new XMLObjectException("Attempt to access undefined parser " + name + " of " + this.toString());
        }
        return this.childParsers.get(name);
    }

    protected boolean parserListExists(String name) {
        return this.childParsers.containsKey(name);
    }

    private void getAndSetAttributes(Node e) throws XMLSyntaxException {
        NamedNodeMap attr = e.getAttributes();
        HashMap<String, Integer> attributes = new HashMap<String, Integer>();
        attributes.putAll(this.attributeTypes);
        for (int nd = 0; nd < attr.getLength(); ++nd) {
            String name = attr.item(nd).getNodeName();
            String val = attr.item(nd).getNodeValue();
            if (!this.attributeTypes.containsKey(name)) {
                StringBuffer abuff = new StringBuffer();
                for (int i = 0; i < attr.getLength(); ++i) {
                    abuff.append("\n" + attr.item(i));
                }
                throw new XMLSyntaxException("Attribute " + name + " is not supported for node " + e.getNodeName() + "\n" + attributes + abuff + "\n");
            }
            this.attributeValues.put(name, val);
            attributes.remove(name);
        }
        if (attributes.containsValue(mandatoryAttribute)) {
            throw new XMLSyntaxException("Some mandatory attributes not specified when parsing " + e.getNodeName());
        }
    }

    public boolean attributeHasValue(String name) {
        return this.attributeValues.containsKey(name);
    }

    protected String getNamedAttribute(String name) throws XMLObjectException {
        if (!this.attributeValues.containsKey(name)) {
            throw new XMLObjectException("Attempt to get attribute " + name + " not associated with object " + this.toString());
        }
        return this.attributeValues.get(name);
    }

    public abstract String parsesNode();

    private boolean nodeValidForParser(Node e) throws XMLSyntaxException {
        String nodeName = e.getNodeName();
        if (!this.parsesNode().contentEquals(nodeName)) {
            throw new XMLSyntaxException("Attempt to parse node " + nodeName + " with " + this.toString());
        }
        return true;
    }

    private void addParser(ObjectParser newParser, String name) {
        if (!this.childParsers.containsKey(name)) {
            this.childParsers.put(name, new ArrayList());
        }
        ArrayList<ObjectParser> parserList = this.childParsers.get(name);
        parserList.add(newParser);
    }

    private void getText(Element e) throws XMLObjectException {
        if (this.textContent != null) {
            throw new XMLObjectException("This element contains more than one text node");
        }
        for (Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
            short type = child.getNodeType();
            if (type != 3) continue;
            this.textContent = child.getNodeValue();
        }
    }

    public void parse(Element e) throws XMLSyntaxException, XMLObjectException {
        try {
            this.nodeValidForParser(e);
            this.getAndSetAttributes(e);
            if (this.isPrimitive()) {
                this.getText(e);
            } else {
                NodeList childNodes = e.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    if (!(childNodes.item(i) instanceof Element)) continue;
                    Element child = (Element)childNodes.item(i);
                    String childName = child.getNodeName();
                    ObjectParser childParser = this.newNamedParser(childName);
                    this.addParser(childParser, childName);
                    childParser.parse(child);
                }
            }
            this.initializeObject();
        }
        catch (XMLException ex) {
            if (this.parent != null) {
                System.out.print("at " + e.getNodeName() + "  " + this.name() + " ");
                System.out.println(ex.getMessage());
                if (ex.getClass() == XMLSyntaxException.class) {
                    throw new XMLSyntaxException("");
                }
                throw new XMLObjectException("");
            }
            System.out.print("at " + e.getNodeName() + "  ");
            System.out.println(ex.getMessage());
            if (ex.getClass() == XMLSyntaxException.class) {
                throw new XMLSyntaxException("");
            }
            throw new XMLObjectException(ex.getMessage());
        }
    }

    public abstract String name();

    public abstract String toString();
}

