/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import jfm.lp.ModelPrimitive;
import jfm.model.Crop;
import jfm.model.Location;
import jfm.model.Types;

public final class RotationPenalty
extends ModelPrimitive {
    private double penalty;

    public RotationPenalty(double pen) {
        this.penalty = pen;
    }

    public double penalty() {
        return this.penalty;
    }

    public void setPenalty(double[] yieldAndCost, Crop.CropCopy cp, Location loc) {
        this.penalty = 0.0;
        this.penalty += cp.costOfYieldPenalty(yieldAndCost[0], loc);
        this.penalty += yieldAndCost[1];
    }

    public double area(int p) {
        if (this.dependentExists(p)) {
            return this.getDependent(p).solution();
        }
        return 0.0;
    }

    protected void updateStructure(Object caller) {
        for (Integer p : this.dependentsKeys()) {
            this.setCoefficient(Types.ObjectiveType.PROFIT, -this.penalty, p);
        }
    }

    public String name() {
        return "Rotation Penalty";
    }
}

