% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_matrix.R
\name{scale_timeseries}
\alias{scale_timeseries}
\title{Scale the BOLD timeseries}
\usage{
scale_timeseries(
  BOLD,
  scale = c("auto", "mean", "sd", "none"),
  transpose = TRUE
)
}
\arguments{
\item{BOLD}{fMRI data as a locations by time (\eqn{V \times T}) numeric
matrix.}

\item{scale}{Option for scaling the BOLD response.

\if{html}{\out{<div class="sourceCode">}}\preformatted{\code{"auto"} (default) will use \code{"mean"} scaling except if demeaned 
}\if{html}{\out{</div>}}

data is detected (if any mean is less than one), in which case \code{"sd"}
scaling will be used instead.

\if{html}{\out{<div class="sourceCode">}}\preformatted{\code{"mean"} scaling will scale the data to percent local signal change.

\code{"sd"} scaling will scale the data by local standard deviation.

\code{"none"} will only center the data, not scale it.
}\if{html}{\out{</div>}}}

\item{transpose}{Transpose \code{BOLD} if there are more columns than rows?
(Because we usually expect the number of voxels to exceed the number of time
points.) Default: \code{TRUE}.}
}
\value{
Scale to units of percent local signal change and centers
}
\description{
Scale the BOLD timeseries
}
