% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-downsample.R
\name{downsample}
\alias{downsample}
\title{Downsample pupil time series with anti-aliasing filtering}
\usage{
downsample(
  eyeris,
  target_fs,
  plot_freqz = FALSE,
  rp = 1,
  rs = 35,
  call_info = NULL
)
}
\arguments{
\item{eyeris}{An object of class \code{eyeris} derived from \code{\link[=load_asc]{load_asc()}}.}

\item{target_fs}{The target sampling frequency in Hz after downsampling.}

\item{plot_freqz}{Boolean flag for displaying filter frequency response
(default FALSE).}

\item{rp}{Passband ripple in dB (default 1).}

\item{rs}{Stopband attenuation in dB (default 35).}

\item{call_info}{A list of call information and parameters. If not provided,
it will be generated from the function call.}
}
\value{
An \code{eyeris} object with downsampled data and updated sampling rate.
}
\description{
This function downsamples pupillometry data by applying an anti-aliasing
filter before decimation. Unlike binning, downsampling preserves the
original temporal dynamics without averaging within bins.
}
\details{
Downsampling reduces the sampling frequency by decimating data points.
The function automatically designs an anti-aliasing filter using the
\code{lpfilt()} function with carefully chosen parameters:
\itemize{
\item \code{ws} (stopband frequency) = Fs_new / 2 (Nyquist freq of new sampling rate)
\item \code{wp} (passband frequency) = ws - max(5, Fs_nq * 0.2)
\item An error is raised if \code{wp < 4} to prevent loss of pupillary responses
}

The resulting time points will be: 0, 1/X, 2/X, 3/X, ..., etc. where X is
the new sampling frequency.
}
\note{
This function is part of the \code{glassbox()} preprocessing pipeline and is not
intended for direct use in most cases. Provide parameters via
\code{downsample = list(...)}.

Advanced users may call it directly if needed.
}
\examples{
demo_data <- eyelink_asc_demo_dataset()

# downsample pupil data recorded at 1000 Hz to 100 Hz with the default params
demo_data |>
  eyeris::glassbox(downsample = list(target_fs = 100)) |>
  plot(seed = 0)

}
\seealso{
\code{\link[=glassbox]{glassbox()}} for the recommended way to run this step as
part of the full \code{eyeris} glassbox preprocessing pipeline.
\code{\link[=bin]{bin()}} for binning functionality.
}
