% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_meta.R
\name{esci_plot_difference_axis_x}
\alias{esci_plot_difference_axis_x}
\title{Add a difference axis to the x axis of an esci forest plot}
\usage{
esci_plot_difference_axis_x(
  myplot,
  difference_table,
  dlim = c(NA, NA),
  d_n.breaks = NULL,
  d_lab = NULL
)
}
\arguments{
\item{myplot}{required ggplot2 plot returned from a plot_meta
function}

\item{difference_table}{required data frame from an esci-estimate that
has a difference-based effect size}

\item{dlim}{Optional 2-item vector to provide the lower and upper
boundaries of the difference axis.  Defaults to c(NA, NA) which is to
auto-set both boundaries.}

\item{d_n.breaks}{Optional numeric > 2 to suggest number of breaks for the
difference axis; defaults to NULL in which case number of breaks
is handled automatically by ggplot}

\item{d_lab}{Optional character to serve as the label for the difference
axis; defaults to NULL}
}
\description{
\code{esci_plot_difference_axis_x} can be used to redraw the
difference axis from a forest plot created with \link{plot_meta}.
You must pass the plot returned from plot_meta and the effect size
table containing the estimated difference.
}
