% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.fit.R
\name{em.fit_pracma}
\alias{em.fit_pracma}
\title{Carry our the Newton-Raphson optimization of the parameters for given weights via the \strong{pracma} hessian,}
\usage{
em.fit_pracma(u, b, x, y, class_probs, weight, tol = 1e-08,
  debug = FALSE, family = poisson(), maxiter = Inf)
}
\arguments{
\item{u}{A 'model.loglike' function.}

\item{b}{The starting parameters.}

\item{x}{An \emph{n}-by-\emph{p} design matrix.}

\item{y}{A vector of observation of length \emph{n}.}

\item{class_probs}{An \emph{n} length vector  of probabilities for the proposed model.}

\item{weight}{A \emph{n} length vector of observation weight terms.  This is currently designed to be either the exposure for a Poisson model or the number of trials for a Logistic model.}

\item{tol}{The tolerance to repeat the Newton-Raphson optimization till.}

\item{debug}{Debugging flag - set to TRUE to output step-by-step change in parameter values.}

\item{family}{The GLM family being considered.}

\item{maxiter}{Maximum number of NR steps to take.}
}
\value{
The parameter values on convergence.
}
\description{
Carry our the Newton-Raphson optimization of the parameters for given weights via the \strong{pracma} hessian,
}
\examples{
x <- model.matrix(~ 1 + factor(wool) + factor(tension), data = warpbreaks)
y <- warpbreaks$breaks
class_probs = rep(1,54)
b <- c(1, 1, 1, 1)

u <- make.logLike(x, y, class_probs = class_probs)

em.fit_pracma(u, b, x, y, class_probs, weight = c(1))
}
