% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cartogram.R
\name{dorling}
\alias{dorling}
\title{Produce a Pseudo-Dorling Cartogram.}
\usage{
dorling(name, centroidx, centroidy, density, nbr = NULL,
  shared.border = NULL, color = NULL, tolerance = 0.1,
  dist.ratio = 1.2, iteration = 9999, polygon.vertex = 100,
  animation = FALSE, sleep.time = 0.3, nbredge = ifelse(is.null(nbr),
  FALSE, TRUE), name.text = TRUE, ggplot2 = FALSE, ...)
}
\arguments{
\item{name}{A vector of region names.}

\item{centroidx}{A vector of x-coordinates of the regions.}

\item{centroidy}{A vector of y-coordinates of the regions.}

\item{density}{A vector of the variable of interest. It will be used as the radii of the circles.}

\item{nbr}{A list of the neighbors of every region. Each element is a vector of all the neighbor names of a region. If nbr=NULL, then it is assumed that no region has any neighbors. If nbr is not NULL, then names should be given to all the elements of the list, for matching the neighbors with the host region name, otherwise the parameter "name" (a character vector) will be used as the element names of nbr. Besides, any values in nbr that are not in "name" will be removed. The length of nbr could be different from the length of "name", but any element in nbr whose name is not in "name" will be removed too.}

\item{shared.border}{A matrix of the counts of shared borders, typically generated from the function \code{border_summary_length()}. It is used to scale the attract force.}

\item{color}{a vector of color to fill in the circles or polygons. Auto-completed if the length does not match with name.}

\item{tolerance}{Tolerant value for the sum of overlapped radii.}

\item{dist.ratio}{The threshold to determine whether an attract force is added. It is applied to the ratio of the distance between two centroids and the sum of the two radii.}

\item{iteration}{The limit of the number of iterations. Default to be 9999.}

\item{polygon.vertex}{The number of vertice of the circle. Default to be 100. If polygon.vertex=4 then diamonds applies. If polygon.vertex=6, then hexagon applies.}

\item{animation}{Whether to show the movements of centroids.}

\item{sleep.time}{Only works when animation=TRUE.}

\item{nbredge}{whether to draw the lines between neighbor regions.}

\item{name.text}{whether to print the region names on the circles or polygons.}

\item{ggplot2}{whether to use ggplot2 to draw the cartogram.}

\item{...}{other things}
}
\description{
From https://github.com/chxy/cartogram/blob/master/R/dorling.R
Not exported here, but needed for aec_carto_f
}
