% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f33pull.R
\name{f33pull}
\alias{f33pull}
\title{A function to import and process F33 data}
\format{A data frame with 14 variables: \describe{ \item{year}{data year}
  \item{State}{State name} \item{STATE_FIPS}{State code} \item{NCEISD}{NCES
  school district ID} \item{NAME}{School district name} \item{CONUM}{County
  number} \item{ENROLL}{School district enrollment} \item{TFEDREV}{Total
  federal revenue- no EdBuild adjustments} \item{LOCREV_adj}{Local revenue -
  with EdBuild adjustments} \item{LOCREV_adj_PP}{Local revenue per pupil-
  with EdBuild adjustments} \item{STREV_adj}{State revenue - with EdBuild
  adjustments} \item{STREV_adj_PP}{State revenue per pupil - with EdBuild
  adjustments} \item{STLOCREV_adj}{State and local revenue - with EdBuild
  adjustments} \item{STLOCREV_adj_PP}{State and local revenue per pupil -
  with EdBuild adjustments} }}
\source{
\url{https://s3.amazonaws.com/data.edbuild.org/public/Raw+Data/F33/csv/2017.csv}
}
\usage{
f33pull(data_year, path=NULL, additional_var=NULL, keep_calcs=FALSE)
}
\arguments{
\item{data_year}{Four digit year of F33 data you would like to pull.
Available for 2006-2017.}

\item{path}{Path name of F33 file if data is stored on local computer.
Defaults to NULL to pull in F33 data from EdBuild's server.}

\item{additional_var}{List any additional F33 variables you would like to
pull.}

\item{keep_calcs}{Do you want to keep all of the variables used to calculate
adjusted revenues? Defaults to FALSE.}
}
\value{
A dataframe where each observation is a school district.
}
\description{
This function imports the US Census, Annual Survey of School System Finances
(F33) data with standard EdBuild processing steps applied to revenues.
}
\note{
The following processing was made to state and local revenues for each
  school district:

  \enumerate{ \item Revenues are multiplied by 1,000.

  \item Sale of property (U11) is removed from local revenue.

  \item Capital outlay and debt service programs (C11) is removed from state
  revenue.

  \item In Arkansas, the Census state NCES local revenue (C24) is subtracted
  from state revenues and added to local revenues for all districts in the
  state.

  \item In Texas, recapture, reported as payments to state governments (L12),
  is subtracted from local revenue.

  \item Charter passthrough dollars, V92, is subtracted proportionately from
  state and local revenues since students attending charter schools are not
  included in F33 enrollment. }

  For full details about F33 processing please visit
  \href{https://edbuild.org/content/dividing-lines/main/methodology}{EdBuild's
  dividing lines map site}.
}
\examples{
\donttest{f33_2017 <- f33pull(data_year="2017",
                    additional_var=c("V40", "TCAPOUT"),
                    keep_calcs=FALSE)}
}
\seealso{
\code{\link{f33pull_raw}}
}
\keyword{EdBuild}
\keyword{F33}
\keyword{data}
