\name{plotebv}
\alias{plotebv}
\title{Plot EBV}
\description{This function aims to display level plots for remote sensing
products using common scale-bars via the implementation of
the \code{rasterVis} library.}
\usage{plotebv(ebv, col.regions = rev(viridis_pal(option = "D")(255)), 
    ...)}
\arguments{
  \item{ebv}{\code{Raster*}. Raster Object.}
  \item{col.regions}{. Color
palette. If
null then
\code{viridis_pal(option
= 'D')} is
implemented.}
  \item{\dots}{. Further arguments in \code{panel.levelplot()}}
}

\value{\code{levelplot}.}

\author{Wilson Lara Henao <wilarhen@gmail.com> [aut, cre], Victor Gutierrez-Velez [aut], Ivan Gonzalez [ctb], Maria C. Londono [ctb]}




\examples{
## Brick with structural Essential Biodiversity Variables covering the
## extent of a location in the northern Amazon basin (Colombia):
path. <- system.file('amazon.grd',package = 'ecochange')
amazon <- brick(path.)

## Changes in layers of tree-canopy cover (TC) in the 'amazon'
## brick are computed:
def <- echanges(amazon, eco = 'TC',
                change = 'lossyear',
                eco_range = c(1,80),
                get_unaffected = TRUE,
                binary_output = FALSE,
                mc.cores = 2)

## Function 'plotebv' allows comparing rasters using a common scale bar:
plotebv(def)
}
