% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globe.R
\name{e_globe}
\alias{e_globe}
\title{Globe}
\usage{
e_globe(e, environment = NULL, base.texture = NULL,
  height.texture = NULL, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{environment}{Texture of background.}

\item{base.texture}{Base texture of globe.}

\item{height.texture}{Texture of height.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add globe.
}
\examples{
\dontrun{
url <- paste0("https://ecomfe.github.io/echarts-examples/",
              "public/data-gl/asset/data/population.json")
data <- jsonlite::fromJSON(url)
data <- as.data.frame(data)
names(data) <- c("lon", "lat", "value")

data \%>\% 
  e_charts(lon) \%>\% 
  e_globe(
    environment = e_stars_texture(),
    base.texture = e_globe_texture(),
    height.texture = e_globe_texture(),
    displacementScale = 0.04
  ) \%>\% 
  e_bar_3d(lat, value, "globe") \%>\% 
  e_visual_map(show = FALSE)
}

}
\seealso{
\code{\link{e_country_names}}, \href{Additional arguments}{http://echarts.baidu.com/option-gl.html#globe}
}
