% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{e_clean}
\alias{e_clean}
\title{Clean}
\usage{
e_clean(e)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}
}
\description{
Removes base \code{data.frame}.
}
\details{
Removes the core database after all operations are exectuted, lightens up the load on final visualisation.
}
\examples{
df <- data.frame(
  x = 1:10,
  y = round(
    runif(10, 1, 100), 2
  ) 
)

df \%>\% 
  e_charts(x) \%>\% 
  e_line(y) \%>\% 
  e_format_y_axis(suffix = "\%") \%>\%
  e_format_x_axis(prefix = "A") \%>\% 
  e_clean()

}
