% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dua.R
\name{see_dua_options}
\alias{see_dua_options}
\title{Show DUA crosswalk options}
\usage{
see_dua_options(level = NULL, sort_vars = TRUE, ...)
}
\arguments{
\item{level}{String name or vector of string names of levels to
show.}

\item{sort_vars}{Sort variables alphabetically when printing
restrictions; if \code{FALSE}, prints in the order saved in the
crosswalk file}

\item{...}{For debugging.}
}
\description{
Once the DUA crosswalk has been loaded, show the available
restriction levels with associated data element names.
}
\examples{
## --------------
## Setup
## --------------
## set DUA crosswalk
dua_cw <- system.file('extdata', 'dua_cw.csv', package = 'duawranglr')
set_dua_cw(dua_cw)
## --------------

## see level i options
see_dua_options(level = 'level_i')

## compare two levels of options
see_dua_options(level = c('level_i','level_ii'))

## show all option levels
see_dua_options()

}
