% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{pull}
\alias{pull}
\title{Pull data object from stack frame (head) which matches specified parameters.}
\usage{
pull(
  stack,
  profile = "default",
  filename = NULL,
  error = .error,
  params = NULL,
  ...
)
}
\arguments{
\item{stack}{Stack you want to pull from.}

\item{profile}{Profile to use. 'default' will be used if profile is not specified.}

\item{filename}{Filename if you want to save downloaded file to disk.
Lifespan of URL is limited by minutes, so filename is highly recommended for large files (> 5Mb),
especially in the case of interactive computations. Specify the parameter in the case of non-text data.}

\item{error}{HTTP error handling function.}

\item{params}{Optional parameters to match.}

\item{...}{Parameters to match. Can be used as alternative to \code{params}. In the case of both are present this one will be merged into params.}
}
\value{
If filename is not NULL then it will be filename itself, otherwise it can be URL in the case of large files.
}
\description{
Pull data object from stack frame (head) which matches specified parameters.
}
\examples{
\donttest{
df <- read.csv(pull("/public_datasets/fusionbase/covid19-germany", "Bundesland name"="All"))
summary(df)
}
}
