% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_drake_graph.R
\name{text_drake_graph}
\alias{text_drake_graph}
\title{Show a workflow graph as text in your terminal window.
\lifecycle{stable}}
\usage{
text_drake_graph(
  ...,
  from = NULL,
  mode = c("out", "in", "all"),
  order = NULL,
  subset = NULL,
  targets_only = FALSE,
  make_imports = TRUE,
  from_scratch = FALSE,
  group = NULL,
  clusters = NULL,
  show_output_files = TRUE,
  nchar = 1L,
  print = TRUE,
  config = NULL
)
}
\arguments{
\item{...}{Arguments to \code{\link[=make]{make()}}, such as \code{plan} and \code{targets}.}

\item{from}{Optional collection of target/import names.
If \code{from} is nonempty,
the graph will restrict itself to
a neighborhood of \code{from}.
Control the neighborhood with
\code{mode} and \code{order}.}

\item{mode}{Which direction to branch out in the graph
to create a neighborhood around \code{from}.
Use \code{"in"} to go upstream,
\code{"out"} to go downstream,
and \code{"all"} to go both ways and disregard
edge direction altogether.}

\item{order}{How far to branch out to create
a neighborhood around \code{from}. Defaults to
as far as possible. If a target is in the neighborhood, then
so are all of its custom \code{\link[=file_out]{file_out()}} files if
\code{show_output_files} is \code{TRUE}.
That means the actual graph order may be slightly greater than
you might expect, but this ensures consistency
between \code{show_output_files = TRUE} and
\code{show_output_files = FALSE}.}

\item{subset}{Optional character vector.
Subset of targets/imports to display in the graph.
Applied after \code{from}, \code{mode}, and \code{order}.
Be advised: edges are only kept for adjacent nodes in \code{subset}.
If you do not select all the intermediate nodes,
edges will drop from the graph.}

\item{targets_only}{Logical,
whether to skip the imports and only include the
targets in the workflow plan.}

\item{make_imports}{Logical, whether to make the imports first.
Set to \code{FALSE} to increase speed and risk using obsolete information.}

\item{from_scratch}{Logical, whether to assume all the targets
will be made from scratch on the next \code{\link[=make]{make()}}.
Makes all targets outdated, but keeps information about
build progress in previous \code{\link[=make]{make()}}s.}

\item{group}{Optional character scalar, name of the column used to
group nodes into columns. All the columns names of your original \code{drake}
plan are choices. The other choices (such as \code{"status"}) are column names
in the \code{nodes} . To group nodes into clusters in the graph,
you must also supply the \code{clusters} argument.}

\item{clusters}{Optional character vector of values to cluster on.
These values must be elements of the column of the \code{nodes} data frame
that you specify in the \code{group} argument to \code{drake_graph_info()}.}

\item{show_output_files}{Logical, whether to include
\code{\link[=file_out]{file_out()}} files in the graph.}

\item{nchar}{For each node, maximum number of characters of the node label
to show. Can be 0, in which case each node is a colored box
instead of a node label.
Caution: \code{nchar} > 0 will mess with the layout.}

\item{print}{Logical. If \code{TRUE}, the graph will print to the console
via \code{message()}. If \code{FALSE}, nothing is printed. However, you still
have the visualization because \code{text_drake_graph()} and
\code{render_text_drake_graph()} still invisibly return a character string
that you can print yourself with \code{message()}.}

\item{config}{Deprecated.}
}
\value{
A \code{visNetwork} graph.
}
\description{
This is a low-tech version of \code{\link[=vis_drake_graph]{vis_drake_graph()}}
and friends. It is designed for when you do not have access
to the usual graphics devices for viewing visuals in an interactive
R session: for example, if you are logged into a remote machine
with SSH and you do not have access to X Window support.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
# Plot the network graph representation of the workflow.
pkg <- requireNamespace("txtplot", quietly = TRUE) &&
  requireNamespace("visNetwork", quietly = TRUE)
if (pkg) {
text_drake_graph(my_plan)
make(my_plan) # Run the project, build the targets.
text_drake_graph(my_plan) # The black nodes from before are now green.
}
}
})
}
}
\seealso{
\code{\link[=render_text_drake_graph]{render_text_drake_graph()}}, \code{\link[=vis_drake_graph]{vis_drake_graph()}},
\code{\link[=sankey_drake_graph]{sankey_drake_graph()}}, \code{\link[=drake_ggraph]{drake_ggraph()}}
}
