#' Expected concentration data
#'
#' @name ecdata
#' @docType data
#' 
#' @description Expected concentration data based on multiplex 
#' immunoassays experiments.
#' 
#' @format A \code{data.frame} with the expected concentration of 30 analytes 
#' of one plate. It consists in 1 background sample, 3 positives controls
#' and 16 dilution points (first dilution is duplicated).
#' 
#' \itemize{
#' \item{\code{sample}}{: type of sample (background, control or standard).}
#' \item{\code{analyte}}{: analyte tested.}
#' \item{\code{ec}}{: expected concentration value.}
#' }
#' 
#' 
#' @keywords data
NULL




