% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primary-keys.R
\name{dm_add_pk}
\alias{dm_add_pk}
\title{Add a primary key}
\usage{
dm_add_pk(
  dm,
  table,
  columns,
  ...,
  autoincrement = FALSE,
  check = FALSE,
  force = FALSE
)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{table}{A table in the \code{dm}.}

\item{columns}{Table columns, unquoted.
To define a compound key, use \code{c(col1, col2)}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{autoincrement}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
If \code{TRUE}, the  column specified in \code{columns} will be populated
automatically with a sequence of integers.}

\item{check}{Boolean, if \code{TRUE}, a check is made if the combination of columns is a unique key of the table.}

\item{force}{Boolean, if \code{FALSE} (default), an error will be thrown if there is already a primary key
set for this table.
If \code{TRUE}, a potential old \code{pk} is deleted before setting a new one.}
}
\value{
An updated \code{dm} with an additional primary key.
}
\description{
\code{dm_add_pk()} marks the specified columns as the primary key of the specified table.
If \code{check == TRUE}, then it will first check if
the given combination of columns is a unique key of the table.
If \code{force == TRUE}, the function will replace an already
set key, without altering foreign keys previously pointing to that primary key.
}
\details{
There can be only one primary key per table in a \code{\link{dm}}.
It's possible though to set an unlimited number of unique keys using \code{\link[=dm_add_uk]{dm_add_uk()}}
or adding foreign keys pointing to columns other than the primary key columns with \code{\link[=dm_add_fk]{dm_add_fk()}}.
}
\examples{
\dontshow{if (rlang::is_installed(c("nycflights13", "DiagrammeR"))) withAutoprint(\{ # examplesIf}
nycflights_dm <- dm(
  planes = nycflights13::planes,
  airports = nycflights13::airports,
  weather = nycflights13::weather
)

nycflights_dm \%>\%
  dm_draw()

# Create primary keys:
nycflights_dm \%>\%
  dm_add_pk(planes, tailnum) \%>\%
  dm_add_pk(airports, faa, check = TRUE) \%>\%
  dm_add_pk(weather, c(origin, time_hour)) \%>\%
  dm_draw()

# Keys can be checked during creation:
try(
  nycflights_dm \%>\%
    dm_add_pk(planes, manufacturer, check = TRUE)
)
\dontshow{\}) # examplesIf}
}
\seealso{
Other primary key functions: 
\code{\link{dm_add_uk}()},
\code{\link{dm_get_all_pks}()},
\code{\link{dm_get_all_uks}()},
\code{\link{dm_has_pk}()},
\code{\link{dm_rm_pk}()},
\code{\link{dm_rm_uk}()},
\code{\link{enum_pk_candidates}()}
}
\concept{primary key functions}
