% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{is.randomFactor}
\alias{is.randomFactor}
\alias{is.fixedFactor}
\alias{is.factorDesign}
\alias{is.designFactor}
\title{Checking factor design data types}
\usage{
is.randomFactor(fac)

is.fixedFactor(fac)

is.factorDesign(fac)

is.designFactor(fac)
}
\arguments{
\item{fac}{Object to check.}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
Check if argument is a design factor (either random or fixed factor), specifically a random factor, a fixed factor or a factor design.
}
\section{Functions}{
\itemize{
\item \code{is.randomFactor}: Check if argument is a random factor.

\item \code{is.fixedFactor}: Check if argument is a fixed factor.

\item \code{is.factorDesign}: Check if argument is a factor design.
}}

\examples{

x <- fixed.factor("factor", c("level1","level2"))
y <- random.factor("factor")

stopifnot(is.fixedFactor(x) && !is.randomFactor(x))
stopifnot(!is.fixedFactor(y) && is.randomFactor(y))
stopifnot(is.designFactor(x) && is.designFactor(y))

}
