% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{random.factor}
\alias{random.factor}
\title{Random factors}
\usage{
random.factor(
  name,
  groups = character(0),
  instances = 1L,
  assign = "latin.square",
  ...
)
}
\arguments{
\item{name}{Name of the random factor as a character vector. Typically, this should be a length-1 vector (i.e., a single string) but you may pass multiple names of random factors whose interaction is to be nested in groups (see *Assignment Constraints*).}

\item{groups}{Names of fixed and random factors that are to be used as grouping (nesting/between) levels.}

\item{instances}{Number of times (as a single integer value) each level (instantiation) is to be replicated.}

\item{assign}{For random factor interactions, use this method for counterbalancing instance assignment (see Assignment Constraints)}

\item{...}{Additional arguments to be stored as \code{extra} values.}
}
\value{
An instance of the class \code{randomFactor}.
}
\description{
This function creates an instance of \code{randomFactor} to be used in a \code{factorDesign}. A random factor is typically related to an experimental unit such as Subject, Item, Experimenter, ect. and does not have preset levels.
}
\section{Nesting Random Factors}{

A typical case of nesting in a psychological experiment is to vary a factor between subjects. That means that each subject would only be assigned to one condition of the nesting fixed factor (such as type of instruction). All other fixed factors that are not listed under `groups` are considered to vary within the random factor. Note that nesting increases the number of replications of the random factor.

Note that a random factor may be nested within fixed and/or other random factors but fixed factors may only be nested within levels of other fixed factors.
}

\section{Assignment Constraints}{

A random interaction (a random factor instantiated with more than one name) governs the assignment of the co-occurence of the listed random factors.
That means that, for example, \code{random.factor(c("Subject","Item"), groups="correct")} ensures that the assignment of a Subject and Item to one another occurs in only *one* of the conditions of \code{correct}.
You may use \code{assign = '...'} to provide the method to counterbalance the assignment. By default, \code{'latin.square'} is used but you may also use \code{'random.order'} or \code{'permutations'}. Note that, depending on the assignment method you use, the constituting random factors (in this case \code{Subject} and \code{Item}) will be replicated n-times (\code{n} being the number of conditions of the nesting factors) for \code{'latin.square'} and \code{'random.order'} and n!-times for \code{'permutations'}.
}

\examples{
# A random factor Subject that nests factors blockOrder and gender,
# i.e. blockOrder and gender are "between-subject"

random.factor("Subject", groups=c("blockOrder", "gender"))

# A random factor Item without any grouping
random.factor("Item")


}
\seealso{
\code{\link[designr]{fixed.factor}}
}
