% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{dptrim}
\alias{dptrim}
\title{Automatically trim an individual density profile on both sides}
\usage{
dptrim(dp, return.plot = FALSE, return.fail = FALSE, silent = FALSE)
}
\arguments{
\item{dp}{An dp object, see \code{dpload}}

\item{return.plot}{Return a plot instead of dp object? If TRUE,
returns a plot instead of a dp object. When return.fail = TRUE,
it returns a list of three: dp object, start trimming success
and end trimming success.}

\item{return.fail}{Should information on the success of trimming be
included when returning a dp object?}

\item{silent}{Mute detection warnings, used when calling on list. A
list of trimmed dp objects, a result of calling dtriml or
dptriml_s on a dp list with return.fail = FALSE.}
}
\value{
A trimmed dp object, with the beginning and ending
  removed, if they were detected. When return.plot = TRUE, it
  returns a plot displaying the process.
}
\description{
Calls dpdetect_s and dpdetect_e on a given dp object and
returns a trimmed dp object with the the row before the starting
point and after the ending removed. If \code{return.plot = TRUE},
it will return a plot displaying the dp object with detected
starting and ending point. If called with the option
\code{return.fail = FALSE} and \code{return.plot = FALSE}, the
returned object will also include information on whether both
cutoff points were detected. If starting/ending point not detected,
dp object is returned with no changes. When running on a list of
dp objects, use \code{dptriml}.
}
\examples{
\donttest{
## load a single dp file
dp  <- dpload(system.file("extdata", "00010001.dpa", package = "densitr"))
## trim the measurements
dp.trimmed <- dptrim(dp)
## plot trimming
dptrim(dp, return.plot = TRUE)
}
}
\seealso{
dptriml, dptrim_s, dptriml_s
}
