% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbcsp.R
\name{train.dbcsp}
\alias{train.dbcsp}
\title{Training process of a dbcsp object, using LDA classifier.}
\usage{
\method{train}{dbcsp}(x, selected_q=x@q, fold=x@fold, seed=x@seed, verbose=TRUE,...)
}
\arguments{
\item{x}{object of class \code{\link[=dbcsp-class]{dbcsp}}.}

\item{selected_q}{integer value indicating the number of vectors to use when training the model, by default \code{selected_q=x@q}.}

\item{fold}{integer value, by default \code{fold=x@fold}. It controls the number of partitions. If \code{fold==1} a train/test
split is performed, with p=0.2 for test indices.}

\item{seed}{numeric value, by default \code{fold=x@seed}. Set a seed to ensure reproducible results.}

\item{verbose}{logical}

\item{...}{not currently used.}
}
\value{
The \code{\link[=dbcsp-class]{dbcsp}} object with the training results saved as list in \code{x@out}:
\itemize{
\item \code{vectors} The projection vectors obtained after applying CSP.
\item \code{eig} The eigenvalues obtained after applying CSP.
\item \code{proy} The variance values of the projected signals obtained after applying CSP.
\item \code{acc} The mean accuracy value obtained for training data applying cross validation.
\item \code{used_folds} List of the folds used in the cross validation.
\item \code{folds_acc} Accuracy values for each of the folds of the cross validation.
\item \code{model} The trained LDA classifier.
\item \code{selected_q} The number of vectors used when training.
}
}
\description{
This function applies DB-CSP to the instances and perform the training of a Linear Discriminant
Analysis (LDA) classifier using the object data.
}
\examples{
# Read data from 2 classes
x <- AR.data$come[1:20]
y <- AR.data$five[1:20]
mydbcsp <- new("dbcsp", X1 = x, X2 = y)
mydbcsp <- train(mydbcsp,fold=3)
print(mydbcsp@out$acc)
}
\seealso{
\code{\link[=dbcsp-class]{dbcsp}}, \code{\link[=print.dbcsp]{print}}, \code{\link[=summary.dbcsp]{summary}}, \code{\link{selectQ}}, \code{\link[=predict.dbcsp]{predict}}, \code{\link[=plot.dbcsp]{plot}}, \code{\link[=boxplot.dbcsp]{boxplot}}
}
