% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relation.R
\name{relation}
\alias{relation}
\alias{relation<-}
\alias{related_create}
\alias{is.related}
\alias{related_item}
\alias{related_item<-}
\title{Add or retrieve related items (DataCite/Dublin Core)}
\usage{
relation(x)

relation(x) <- value

related_create(
  relatedIdentifier,
  relationType,
  relatedIdentifierType,
  resourceTypeGeneral = NULL
)

is.related(x)

related_item(x)

related_item(x) <- value
}
\arguments{
\item{x}{A dataset object created with \code{\link[=dataset_df]{dataset_df()}} or \code{\link[=as_dataset_df]{as_dataset_df()}}.}

\item{value}{A \code{related} object from \code{\link[=related_create]{related_create()}} or a character.
Vectors of characters are also supported and will be converted to a list of
\code{"related"} objects.}

\item{relatedIdentifier}{A string with the identifier of the related
resource.}

\item{relationType}{A string naming the relation type (per DataCite
vocabulary).}

\item{relatedIdentifierType}{A string naming the identifier type (\code{"DOI"},
\code{"URL"}, etc.).}

\item{resourceTypeGeneral}{Optional: a string naming the general type of the
related resource.}
}
\value{
\itemize{
\item \code{relation(x)} returns:
\itemize{
\item a single structured \code{"related"} object (from \code{\link[=related_create]{related_create()}}) if only
one relation is present,
\item a list of \code{"related"} objects if multiple relations are present,
\item otherwise it falls back to the bibentry field (\code{relatedidentifier} for
DataCite or \code{relation} for Dublin Core).
}
\item \code{relation(x) <- value} sets the \code{"relation"} attribute (structured object
or list of objects) and the bibentry string fields (\code{relatedidentifier} and
\code{relation}), and returns the dataset invisibly.
\item \code{related_create()} constructs a structured \code{"related"} object.
\item \code{is.related(x)} returns \code{TRUE} if \code{x} inherits from class \code{"related"}.
}
}
\description{
Manage related resources for a dataset using a unified accessor.
\itemize{
\item For \strong{DataCite 4.x}, this maps to \code{relatedIdentifier} (+ type & relation).
\item For \strong{Dublin Core}, this maps to \code{dct:relation} (string).
}
}
\details{
To remain compatible with \code{\link[utils:bibentry]{utils::bibentry()}}, the bibentry stores
only the
\strong{string identifier} (e.g., DOI/URL). The full structured object created by
\code{\link[=related_create]{related_create()}} is preserved in the \code{"relation"} attribute.

A \code{"related"} object is a small S3 list with the following elements:
\itemize{
\item \code{relatedIdentifier}: the related resource identifier (DOI, URL, etc.)
\item \code{relationType}: the DataCite relation type (e.g., \code{"IsPartOf"}, \code{"References"})
\item \code{relatedIdentifierType}: the type of identifier (\code{"DOI"}, \code{"URL"}, etc.)
\item \code{resourceTypeGeneral}: optional, the general type of the related resource (e.g., \code{"Text"}, \code{"Dataset"})
}
}
\examples{
df <- dataset_df(data.frame(x = 1))
relation(df) <- related_create(
  relatedIdentifier = "10.1234/example",
  relationType = "IsPartOf",
  relatedIdentifierType = "DOI"
)
relation(df) # structured object
get_bibentry(df)$relation # "10.1234/example"
get_bibentry(df)$relatedidentifier # "10.1234/example"

# Character input is normalized to a DOI/URL with default types
relation(df) <- "https://doi.org/10.5678/xyz"
relation(df) # structured object (relationType/Type filled with defaults)

# Create related object directly
rel <- related_create("https://doi.org/10.5678/xyz", "References", "DOI")
is.related(rel) # TRUE

}
\seealso{
Other bibliographic helper functions: 
\code{\link{contributor}()},
\code{\link{creator}()},
\code{\link{dataset_format}()},
\code{\link{dataset_title}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{get_bibentry}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{rights}()},
\code{\link{subject}()}
}
\concept{bibliographic helper functions}
