% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{RequestFrozenModel}
\alias{RequestFrozenModel}
\title{Train a new frozen model with parameters from specified model}
\usage{
RequestFrozenModel(model, samplePct = NULL, trainingRowCount = NULL)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by
the function GetModel, or each element of the list returned by
the function ListModels.}

\item{samplePct}{Numeric, specifying the percentage of the training
dataset to be used in building the new model}

\item{trainingRowCount}{integer. The number of rows to use to train
the requested model.}
}
\value{
An integer value that can be used as the modelJobId parameter
in subsequent calls to the GetModelFromJobId function.

An integer value that can be used as the modelJobId parameter
  in subsequent calls to the GetModelFromJobId function.
}
\description{
Frozen models use the same tuning parameters as their parent model
instead of independently optimizing them to allow efficiently
retraining models on larger amounts of the training data.
}
\details{
Either `sample_pct` or `training_row_count` can be used to specify the amount of data to
use, but not both. If neither are specified, a default of the maximum amount of data that
can safely be used to train any blueprint without going into the validation data will be
selected.
In smart-sampled projects, `samplePct` and `trainingRowCount` are assumed to be in terms of rows
of the minority class.

Note : For datetime partitioned projects, use ``RequestFrozenDatetimeModel` instead
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModel(projectId, modelId)
  RequestFrozenModel(model, samplePct = 10)
}
}
