% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataStores.R
\name{GetDataStore}
\alias{GetDataStore}
\title{Returns information about a particular data store.}
\usage{
GetDataStore(dataStoreId)
}
\arguments{
\item{dataStoreId}{character. The id of the data store.}
}
\value{
A list containing information on the particular data store:
\itemize{
  \item id character. The dataStoreId of the data store.
  \item canonicalName character. The user-friendly name of the data store.
  \item type character. The type of data store.
  \item updated datetime. A timestamp for the last time the data store was updated.
  \item creator character. The userId of the user who created the data store.
  \item params list. A list specifying the data store parameters.
}
}
\description{
Returns information about a particular data store.
}
\examples{
\dontrun{
 dataStoreId <- "5c1303269300d900016b41a7"
 GetDataStore(dataStoreId)
}
}
