% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.traces_dm_list}
\alias{plot.traces_dm_list}
\alias{plot.traces_dm}
\title{Plot Traces of a Drift Diffusion Model}
\usage{
\method{plot}{traces_dm_list}(
  x,
  ...,
  col = NULL,
  col_b = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "Time",
  ylab = "Evidence",
  lty = 1,
  type = "l",
  legend = NULL,
  legend_pos = "topright"
)

\method{plot}{traces_dm}(
  x,
  ...,
  col = NULL,
  col_b = NULL,
  xlim = NULL,
  ylim = NULL,
  xlab = "Time",
  ylab = "Evidence",
  lty = 1,
  type = "l"
)
}
\arguments{
\item{x}{an object of type \code{traces_dm_list} or \code{traces_dm}, containing the
traces to be plotted, resulting from a call to \link{simulate_traces}.}

\item{...}{additional arguments passed to the \link{plot}, \link[graphics:points]{graphics::points},
and \link[graphics:legend]{graphics::legend} functions. Oftentimes, this will (unfortunately) lead
to an error due to a clash of arguments.}

\item{col}{character, vector of colors for the evidence accumulation traces,
one per condition. Defaults to a rainbow palette if not specified.}

\item{col_b}{character, a vector of colors for the boundary lines.
Defaults to black for all conditions.}

\item{xlim, ylim}{numeric vectors of length 2, specifying the x and y axis
limits.}

\item{xlab, ylab}{character, labels for the x and y axes.}

\item{lty}{integer, line type for both the traces and boundary lines.}

\item{type}{character, type of plot to use for traces and boundaries.}

\item{legend}{character vector, specifying legend labels, corresponding to
the conditions in the traces. Defaults to the condition names.}

\item{legend_pos}{character, specifying the position of the legend on the
plot.}
}
\value{
Nothing (\code{NULL}; invisibly)
}
\description{
Creates a basic plot showing simulated traces (simulated evidence
accumulation processes) from a drift diffusion model. Such plots are useful
for exploring and testing model behavior, allowing users to visualize the
traces.
}
\details{
\code{plot.traces_dm_list()} iterates over all conditions and plots the traces.
It includes a legend with condition labels.

\code{plot_traces_dm} only plots the traces provided (i.e., traces for one
condition)

Boundaries and traces are color-coded according to \code{col} and \code{col_b}. The
function automatically generates the upper and lower boundaries based on
the information stored within \code{x}.
}
\examples{
# get a couple of traces for demonstration purpose
a_model <- dmc_dm()
some_traces <- simulate_traces(a_model, k = 3)

# Plots for traces_dm_list objects ----------------------------------------
# basic plot
plot(some_traces)

# a slightly more beautiful plot :)
plot(some_traces,
  col = c("green", "red"),
  xlim = c(0, 0.35),
  xlab = "Time [s]",
  ylab = bquote(Realizations ~ of ~ X[t]),
  legend_pos = "bottomright"
)

# Plots for traces_dm objects ---------------------------------------------
# we can also extract a single set of traces and plot them
one_set_traces <- some_traces$comp
plot(one_set_traces)

# modifications to the plot generally work in the same way
plot(one_set_traces,
  col = "green",
  xlim = c(0, 0.35),
  xlab = "Time [s]",
  ylab = bquote(Realizations ~ of ~ X[t])
)

}
\seealso{
\link{simulate_traces}
}
