\name{plot.hcoef.post}
\alias{plot.hcoef.post}
\concept{MCMC}
\concept{S3 method}
\concept{plot}
\concept{hierarchical model}
\title{Plot Method for Hierarchical Model Coefficients }
\description{
   \code{plot.hcoef.post} plots arrays of hierarchical coefficients.}
\usage{
\method{plot}{hcoef.post}(x,spmname,spm, burnin=trunc(.1*R), nsamp=30, ...)
}
\arguments{
  \item{x}{\samp{betadraw} object generated by the MCMC simulation}
  \item{spmname}{name associated with the thresholded voxels, e.g. "activated", "non-activated"}
  \item{spm}{threshold active, or non-active voxel, coefficients}
  \item{burnin}{n. of draws to burnin, def: .1*R }
  \item{nsamp}{number of random voxels to use in the plots (default: 30)}
  \item{...}{ standard graphics parameters }
}
\details{
See description of similar function in \code{bayesm::plot.bayesm.hcoef}.}
\seealso{
  \code{\link{cudaMultireg.slice}},
  \code{\link{pmeans.hcoef}},
  \code{\link{regpostsim}},
  \code{\link{post.simul.hist}},
  \code{\link{post.simul.betadraw}}
}
\examples{
\dontrun{
## load simulation
fsave <- paste(tempdir(),"/simultest1",fileext = ".sav", sep="")
load(file=fsave)
cat("loaded",fsave,"\n")
vreg <- 2
pmeans <- pmeans.hcoef(out$betadraw) 
px <- regpostsim(pmeans, vreg=vreg)
spma <- px$spma # active voxels
spmn <- px$spmn # non-active voxels
plot(out$betadraw,spmname="activated",spm=spma)
plot(out$betadraw,spmname="non-activated",spm=spmn)
}}
\keyword{ hplot }
