% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSurvival.R
\name{plotSurvival}
\alias{plotSurvival}
\title{Survival curves}
\usage{
plotSurvival(fit, target = NULL, ggtheme = theme_minimal(),
  titleSurv = "Survival curves", xtitle = "Time",
  ytitleSurv = "Probability of survivng up to time t",
  legendtitle = "Group")
}
\arguments{
\item{fit}{a result of fitSurvival function.}

\item{target}{point in time, in which the confidence bounds should be plotted (if NULL, no confidence bounds will be plotted).}

\item{ggtheme}{ggtheme to be used (default: theme_minimal()).}

\item{titleSurv}{a title of a plot (default: "Survival curves").}

\item{xtitle}{a title of x axis (default: "Time").}

\item{ytitleSurv}{a title of y axis (default: "Probability of survivng up to time t")}

\item{legendtitle}{a title of a legend (default: "Group").}
}
\value{
a ggplot containing n graphs, where n is number of risks. Each graph represents survival curves for given risk. One curve corresponds to one group.
}
\description{
Plots survival curves for each risk and group.
}
\examples{
fitS <- fitSurvival(time = LUAD$time, risk = LUAD$event, group = LUAD$gender, cens = "alive")
plotSurvival(fit = fitS, target = 1200)
}
\seealso{
\code{\link[ggplot2]{ggplot}} \code{\link[ggplot2]{ggtheme}}
}
