% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared-methods.R
\name{initialise_dataclass}
\alias{initialise_dataclass}
\title{Initialise a child class of DataClass if it exists}
\usage{
initialise_dataclass(
  class = character(),
  level = "1",
  totals = FALSE,
  localise = TRUE,
  regions,
  verbose = TRUE,
  steps = FALSE,
  get = FALSE,
  type = c("national", "regional"),
  ...
)
}
\arguments{
\item{class}{A character string specifying the \code{DataClass()} to initialise.
Not case dependent and matching is based on either the class name or the its
country definition. For a list of options use \code{get_available_datasets()}.}

\item{level}{A character string indicating the target administrative level
of the data with the default being "1". Currently supported options are
level 1 ("1) and level 2 ("2"). Use \code{get_available_datasets()} for supported
options by dataset.}

\item{totals}{Logical, defaults to FALSE. If TRUE, returns totalled
data per region up to today's date. If FALSE, returns the full dataset
stratified by date and region.}

\item{localise}{Logical, defaults to TRUE. Should region names be localised.}

\item{regions}{A character vector of target regions to be assigned to the
\code{target_regions} field and used to filter the returned data.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should verbose processing
messages and warnings be returned.}

\item{steps}{Logical, defaults to FALSE. Should all processing and cleaning
steps be kept and output in a list.}

\item{get}{Logical, defaults to FALSE. Should the class \code{get} method be
called (this will download, clean, and process data at initialisation).}

\item{type}{A character vector indicating the types of data to
return. Current options include "national" (which are datasets at the
national level which inherit from \code{CountryDataClass}) and
"regional" (which are datasets at the regional level which inherit
directly from \code{DataClass()}).}

\item{...}{Additional arguments to pass to class specific functionality.}
}
\value{
An initialised version of the target class if available,
e.g. \code{Italy()}
}
\description{
This function initialises classes based on the \code{DataClass()}
which allows documented downloading, cleaning, and processing. See the
examples for some potential use cases and the \code{DataClass()} documentation
for more details.
}
\examples{
\dontrun{
# set up a cache to store data to avoid downloading repeatedly
start_using_memoise()

# check currently available datasets
get_available_datasets()

# initialise a data set in the United Kingdom
# at the UTLA level
utla <- UK$new(level = "2")

# download UTLA data
utla$download()

# clean UTLA data
utla$clean()

# inspect available level 1 regions
utla$available_regions(level = "1")

# filter data to the East of England
utla$filter("East of England")

# process UTLA data
utla$process()

# return processed and filtered data
utla$return()

# inspect all data steps
utla$data

# initialise Italian data, download, clean and process it
italy <- initialise_dataclass("Italy", get = TRUE)
italy$return()

# initialise ECDC data, fully process it, and return totals
ecdc <- initialise_dataclass("ecdc", get = TRUE, totals = TRUE)
ecdc$return()
}
}
\seealso{
Data interface functions
\code{\link{CountryDataClass}},
\code{\link{DataClass}},
\code{\link{get_available_datasets}()},
\code{\link{get_national_data}()},
\code{\link{get_regional_data}()}
}
\concept{interface}
