% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{msa_census}
\alias{msa_census}
\title{Metro area population data}
\format{
A data frame with 2797 rows, each representing one core-based
statistical area (including metropolitan and micropolitan statistical
areas, county or county equivalents, and metropolitan divisions). There are
many columns. The most crucial are:

\describe{
\item{CBSA}{Core Based Statistical Area code. These are unique identifiers
used, for example, as the \code{geo_values} argument to \code{covidcast_signal()}
when requesting data from specific metro areas (with \code{geo_type = 'msa'}).}
\item{MDIV}{Metropolitan Division code}
\item{STCOU}{State and county code}
\item{NAME}{Name or title of the area.}
\item{LSAD}{Legal/Statistical Area Description, identifying if this is a
metropolitan or micropolitan area, a metropolitan division, or a county.}
\item{STATE}{State FIPS code.}
\item{POPESTIMATE2019}{Estimate of the area's resident population as of
July 1, 2019.}
}
}
\source{
United States Census Bureau, at
\url{https://www2.census.gov/programs-surveys/popest/datasets/2010-2019/metro/totals/cbsa-est2019-alldata.csv}
}
\usage{
msa_census
}
\description{
Data set on metropolitan area populations, from the 2019 US Census. This
includes metropolitan and micropolitan statistical areas, although the
COVIDcast API only supports fetching data from metropolitan statistical
areas.
}
\references{
Census Bureau documentation of all columns and their meaning:
\url{https://www2.census.gov/programs-surveys/popest/datasets/2010-2019/metro/totals/cbsa-est2019-alldata.pdf}
}
\seealso{
\code{\link[=cbsa_to_name]{cbsa_to_name()}}, \code{\link[=name_to_cbsa]{name_to_cbsa()}}
}
\keyword{datasets}
