% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_fun.R
\name{long_term_flood}
\alias{long_term_flood}
\title{Return flood metrics by county codes for a data frame input}
\usage{
long_term_flood(input_df, threshold = "Q2", flood_type = "flood",
  weight = "Q2")
}
\arguments{
\item{input_df}{Data frame with three columns: \code{county_cd},
\code{start_date}, and \code{end_date}}

\item{threshold}{Character string of the flood threshold to be used in the
analysis (either "Q2" or "NWS"). Defaults to "Q2".}

\item{flood_type}{Character string of the defined flood type based on NWS
classifications (one of "action", "flood", "moderate", or "major")}

\item{weight}{Character string of variable to be used to scale by river size
for weighted averages and scaling point sizes on maps. Options are median
annual flood ("Q2") or drainage area ("DA"). Defaults to "Q2"}
}
\value{
A list with two data frames summarizing data by gage and by county.

  Gage:

  \tabular{lll}{
  Name \tab Type \tab Description\cr
  start_date \tab date \tab Input start date\cr
  end_date \tab date \tab Input end date\cr
  site_no \tab character \tab USGS gage ID\cr
  county_cd \tab character \tab FIPS code of gage county location\cr
  lat \tab numeric \tab Gage latitude\cr
  long \tab numeric \tab Gage longitude\cr
  avg_peak \tab numeric \tab Mean flood ratio for date range
     (discharge/flood threshold)\cr
  flood_dur \tab numeric \tab Number of days in date range
     discharge above flood threshold\cr
  max_peak \tab numeric \tab Maximum value of flood ratio for date
     range (discharge/flood threshold)\cr
  num_missing \tab numeric \tab Number of days in given date
     range with no discharge data at that gage\cr
  Q2 \tab numeric \tab Median annual discharge (cubic feet per second)\cr
  DA \tab numeric \tab Drainage area of the gage (square miles)\cr
  size \tab numeric \tab Relative river size, logarithm of either Q2 or DA
     depending on user specified \code{weight}\cr
  state \tab character \tab State name\cr
  county \tab character \tab County name\cr
  flood \tab character \tab Flood magnitude category based on peak }

  County:

  \tabular{lll}{
  Name \tab Type \tab Description\cr
  county_cd \tab character \tab FIPS code of gage county location\cr
  start_date \tab date \tab Input start date\cr
  end_date \tab date \tab Input end date\cr
  county \tab character \tab County name\cr
  state \tab character \tab State name\cr
  num_gage \tab numeric \tab Number of analyzed gages in county\cr
  max_peak \tab numeric \tab Maximum observed flood ratio\cr
  avg_peak \tab numeric \tab Average flood ratio among county gages\cr
  minor \tab numeric \tab Percentage of gages at or above "minor" flood
     class (flood ratio > 1)\cr
  moderate \tab numeric \tab Percentage of gages at or above "moderate"
     flood class (flood ratio > 1.5)\cr
  major \tab numeric \tab Percentage of gages at or above "major" flood
     class (flood ratio > 2)\cr
  extreme \tab numeric \tab Percentage of gages at or above "extreme"
     flood class (flood ratio > 5)\cr
  max_dur \tab numeric \tab Maximum flood duration in county\cr
  avg_dur \tab numeric \tab Average flood duration in county }

If threshold = "NWS", the columns "minor", "moderate", "major", and "extreme"
are replaced with two columns: "no_flood" and "yes_flood" which show the
percentage of gages in the county with or without flooding.
}
\description{
Access USGS databases to retrieve gages and flow data for the specified
county FIPS codes and the specified date ranges. Flooding
at these gage locations are assessed by one of two metrics. Data can be
returned at the gage level or the county level. This is the same as the
\code{run_flood} function but accepts a data frame as input with multiple
county codes and date ranges for each.
}
\examples{
\dontrun{
#Northern VA flooding every April
county_cd <- c(rep("51013", 5), rep("51107", 5), rep("51059", 5))
start_date <- rep(c("2010-04-01", "2011-04-01", "2012-04-01", "2013-04-01", "2014-04-01"), 3)
end_date <- rep(c("2010-04-30", "2011-04-30", "2012-04-30", "2013-04-30", "2014-04-30"), 3)
input_df <- data.frame(county_cd = county_cd, start_date = start_date, end_date = end_date,
                      stringsAsFactors = FALSE)

#With default values
VA_floods <- long_term_flood(input_df)

#Using NWS values
VA_floods <- long_term_flood(input_df, threshold = "NWS")
}
}
