% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_data.R
\name{time_series_analysis}
\alias{time_series_analysis}
\title{Get time series output}
\usage{
time_series_analysis(flow_data, peaks, gages, county_cd, q2_val, threshold,
  weight = "Q2", Q2_magnitude = "Moderate", filter_data = TRUE)
}
\arguments{
\item{flow_data}{A data frame with discharge data for each USGS gage found
for the specified data range. Output from \code{get_flow_data} function.}

\item{peaks}{A data frame of USGS gage IDs and flood values obtained from
either the \code{find_Q2} or \code{find_NWS} function.}

\item{gages}{A data frame of all USGS gages and metadata obtained from the
\code{get_gages} function. This input is used to add lat/long and county
codes to the summarized output.}

\item{county_cd}{Character vector with the county FIPS code(s)}

\item{q2_val}{A data frame with values of the median annual flood to be used
to compare relative sizes of streams at gage locations (from the \code{find_Q2}
function).}

\item{threshold}{Character string of the flood threshold to be used in the
analysis (either "Q2" or "NWS"). Defaults to "Q2".}

\item{weight}{Character string of variable to be used to scale by river size
for weighted averages and scaling point sizes on maps. Options are median
annual flood ("Q2") or drainage area ("DA"). Defaults to "Q2".}

\item{Q2_magnitude}{Character string of ratio of daily streamflow to Q2 used
as a binary flood threshold. One of "Minor" (1 < Flow / Q2 < 1.5), "Moderate" (< 2),
"Major" (< 5), and "Extreme" (> 5). Defaults to "Moderate".}

\item{filter_data}{Logical. If TRUE only dates with a flood occurring are returned for
both gage and county-level data. If FALSE, all dates are returned.}
}
\value{
A list with two data frames, summarizing the results by gage and by county:

Gage:
\tabular{lll}{
Name \tab Type \tab Description\cr
site_no \tab character \tab USGS gage ID\cr
date \tab date \tab Date of observation\cr
lat \tab numeric \tab Gage latitude\cr
long \tab numeric \tab Gage longitude\cr
county_cd \tab character \tab FIPS code of gage county location\cr
Q2 \tab numeric \tab Median annual discharge (cubic feet per second)\cr
DA \tab numeric \tab Drainage area of the gage (square miles)\cr
size \tab numeric \tab Relative river size, logarithm of either Q2 or DA
     depending on user specified \code{weight}\cr
discharge \tab numeric \tab Observed mean daily discharge (cubic feet per second)\cr
flood_val \tab numeric \tab Selected threshold flood value. Either Q2 or an NWS flood threshold.\cr
flood_ratio \tab numeric \tab Ratio of the observed discharge divided by the defined flood threshold\cr
state \tab character \tab State name\cr
county \tab character \tab County name\cr
flood \tab character \tab Flood magnitude category based on peak
}

County:
\tabular{lll}{
Name \tab Type \tab Description\cr
date \tab date \tab Date of observation\cr
county \tab character \tab County name\cr
state \tab character \tab State name\cr
num_gage \tab numeric \tab Number of analyzed gages in county\cr
max_peak \tab numeric \tab Maximum observed flood ratio\cr
avg_peak \tab numeric \tab Average flood ratio among county gages\cr
minor \tab numeric \tab Percentage of gages at or above "minor" flood class (flood ratio > 1)\cr
moderate \tab numeric \tab Percentage of gages at or above "moderate" flood class (flood ratio > 1.5)\cr
major \tab numeric \tab Percentage of gages at or above "major" flood class (flood ratio > 2)\cr
extreme \tab numeric \tab Percentage of gages at or above "extreme" flood class (flood ratio > 5)\cr
flood_metric \tab numeric \tab Fraction of gages in county experiencing a flood, weighted by river size
     (\code{size} from gage-level output)
}

If threshold = "NWS", the columns "minor", "moderate", "major", and "extreme"
are replaced with two columns: "no_flood" and "yes_flood" which show the
percentage of gages in the county with or without flooding.
}
\description{
Function takes flow data and summarizes flood occurrence through time at
both the gage and county level.
}
\examples{
\dontrun{
va_counties <- get_county_cd("Virginia")
va_gages <- get_gages(va_counties, start_date = "2015-01-01",
                      end_date = "2015-12-31")
va_flow_data <- get_flow_data(va_gages, start_date = "2015-01-01",
                      end_date = "2015-12-31")
va_peaks <- find_q2(va_gages$site_no)
va_time_series <- time_series_analysis(flow_data = va_flow_data, peaks = va_peaks,
                        gages = va_gages, county_cd = va_counties,
                        q2_val = dplyr::rename_(va_peaks, .dots = list(q2 = "flood_val")),
                        threshold = "Q2")
}
}
